<?php

namespace App\Services;

use App\Repositories\MobileAppBrief\MobileAppBriefRepository;
use Exception;
use Illuminate\Support\Facades\Request;

class MobileAppBriefService{
    private $mobileAppBriefRepository, $streakService;

    public function __construct(MobileAppBriefRepository $mobileAppBriefRepository, StreakService $streakService)
    {
        $this->mobileAppBriefRepository = $mobileAppBriefRepository;
        $this->streakService = $streakService;

    }

    public function create($briefDetails)
    {
        try {
            $brief = $this->mobileAppBriefRepository->createBrief($briefDetails);

            $this->streakService->createBox([
                "name" => $data['name'] ?? '',
                "company_name" => $brief['business_name'] ?? '',
                "phone_number" => $brief['phone_number'] ?? '',
                "industry" => '',
                "brief_url" => !empty($brief['encoded_id']) ? route('frontend.app.brief.view', $brief['encoded_id']) : '',
                "email" => $brief['email'] ?? '',
            ]);
            return $brief;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function list($request)
    {
        try {
            $briefs = $this->mobileAppBriefRepository->getAllBriefs($request);
            return $briefs;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function fetchByEncodedID($briefID, $authenticated = false)
    {
        try {
            $brief = $this->mobileAppBriefRepository->getByEncodedID($briefID, $authenticated);
            return $brief;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function getBrief($id)
    {
        try {
            $brief = $this->mobileAppBriefRepository->getBrief($id);
            return $brief;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

}