<?php

namespace App\Repositories\Team;

use App\Models\Team;
use App\Services\GenerateUniqueID;
use Illuminate\Support\Arr;
use Exception;

class TeamRepository implements TeamInterface
{

    protected $teamImagePath = 'backend/images/team/';

    private $generateUniqueID;

    function __construct(GenerateUniqueID $generateUniqueID)
    {
        $this->generateUniqueID = $generateUniqueID;
    }
    // Add or Update team
    public function addOrUpdate(...$args)
    {
        try {
            $id = $args[0]['id'] ?? null;
            $team = Team::findOrNew($id);
            $isNewTeam = $team->id == null;

            if ($isNewTeam) {
                $team->name = $args[0]['name'];
                $team->description = $args[0]['description'];
                $team->target = $args[0]['target'];
                $team->color = $args[0]['color'];
                $team->created_by = $args[0]['created_by'];
            } else {
                $team->name = $args[0]['name'];
                $team->description = $args[0]['description'];
                $team->target = $args[0]['target'];
                $team->color = $args[0]['color'];
                $team->updated_by = $args[0]['updated_by'];
            }

            $team->save();

            $data['success'] = true;
            $data['id'] = $team->id;

            return $data;
        } catch (Exception $ex) {
            $data['success'] = false;
            $data['message'] = $ex->getMessage();

            return $data;
        }
    }

    // Detail of team
    public function team($id)
    {
        return Team::find($id);
    }

    // list of teams
    public function list($select = "")
    {
        return Team::all();
    }

    // Archived team
    public function softDeleteTeam($id)
    {
        try {
            $team = Team::find($id);
            if (!empty($team)) {
                $team->status = 2;
                $team->save();
                $team->delete(); // Soft delete
                $data['id'] = $team->id;
                $data['success'] = true;
                $data['message'] = 'Team Archived Successfully';

                return $data;
            }
        } catch (Exception $ex) {
            $data['success'] = false;
            $data['message'] = $ex->getMessage();

            return $data;
        }
    }

    // Permanent Delete team
    public function forceDeleteTeam($id)
    {
        try {
            $team = Team::withTrashed()->find($id);
            if (!empty($team)) {
                $team->forceDelete(); // Permanent delete
                $data['success'] = true;
                $data['message'] = 'Team Deleted Successfully';

                return $data;
            }
        } catch (Exception $ex) {
            $data['success'] = false;
            $data['message'] = $ex->getMessage();

            return $data;
        }
    }

    // Restore team
    public function restoreTeam($id)
    {
        try {
            $team = Team::withTrashed()->find($id);
            if (!empty($team)) {
                $team->restore(); // Restore the soft-deleted record
                $team->status = 1;
                $team->save();
                $data['id'] = $team->id;
                $data['success'] = true;
                $data['message'] = 'Team Restored Successfully';

                return $data;
            }
        } catch (Exception $ex) {
            $data['success'] = false;
            $data['message'] = $ex->getMessage();

            return $data;
        }
    }

    // Add team metadata
    public function updateTeamMetadata(...$args)
    {
        try {
            $id = $args[0]['id'] ?? null;
            $team = Team::find($id);

            if ($args[0]['metadata']) {
                $metadata = $args[0]['metadata'];

                $metadata = array_filter($metadata, function ($item) {
                    return $item['key'] !== null && $item['value'] !== null;
                });

                $metadata = Arr::pluck($metadata, 'value', 'key');
                $team->metadata = json_encode($metadata);
                $team->updated_by = $args[0]['updated_by'];
            }

            $team->save();

            $data['success'] = true;
            $data['id'] = $team->id;

            return $data;
        } catch (Exception $ex) {
            $data['success'] = false;
            $data['message'] = $ex->getMessage();

            return $data;
        }
    }
}
