<?php

namespace App\Repositories\Payment\TokenCustomer;

use App\Models\PaymentlinkCustomer;
use Carbon\Carbon;

class TokenCustomerRepository implements TokenCustomerInterface
{
    private $linkCustomer;

    public function __construct(PaymentlinkCustomer $linkCustomer)
    {
        $this->linkCustomer = $linkCustomer;
    }

    public function create($paymentLinkID, $customerInfo)
    {
        $customerInfo['paymentlink_id'] = $paymentLinkID;

        return $this->linkCustomer->create($customerInfo);
    }

    public function retrieve($temporaryCustomerID)
    {
    }

    public function update($temporaryCustomerID, $customerInfo)
    {
        $tokenCustomer = $this->linkCustomer->find($temporaryCustomerID);

        if ($tokenCustomer) {
            $tokenCustomer->update($customerInfo);
        }
    }

    public function delete($temporaryCustomerID)
    {
    }

    public function permanentDelete($temporaryCustomerID)
    {
    }
}
