<?php
namespace App\Repositories\Payment\Refund;

use App\Models\Payment;
use App\Services\StripeErrorHandler;
use Exception;
use Stripe\Refund;
use Stripe\Stripe;

class RefundRepository implements RefundInterface {
  protected $payment;

  public function __construct(Payment $payment) {
    $this->payment = $payment;
  }

  public function create($paymentID, $reason, $amount = 0, $refundStatus) {
    try {
      $status = ['partially_refunded'=> 9, 'refund_pending' => 10,'refunded' => 11];

      $payment = $this->payment::select('id','customer_id','payment_link_id','price','discount','currency','ip','intent_id','refund','intent','status')
                          ->where('id', $paymentID)
                          ->with(['link'=> function($query) {
                              $query->select('id', 'payment_gateway');
                              $query->with('gateway:id,name,public_key,secret_key');
                          }])->first();

       // Set your Stripe API key
       Stripe::setApiKey($payment->link->gateway->secret_key);

       $passReason = !empty($reason['reason']) ? $reason['reason'] : 'requested_by_customer';

       // Retrieve payment intent and refund the payment
       if($payment?->intent_id) {
          $refundData = [
            'payment_intent' => $payment->intent_id,
            'reason' => $passReason == 'other' ? 'requested_by_customer' : $passReason
          ];

          if($amount!==0) {
            $refundData['amount'] = $amount;
          }

          $refund = Refund::create($refundData);

          // Handle successful refund
          Payment::where('id', $paymentID)->update([
              'refund' => response()->json($refund)->content(),
              'status' => $status[$refundStatus]
          ]);


          return $refund;
       } else {
           throw new Exception('Payment Intent is not available.');
       }
    } catch (Exception $e) {
      StripeErrorHandler::handle($e);
    }
  }

  public function retrieve() {
  }

  public function update() {
  }

  public function list() {
  }

}
