<?php
namespace App\Repositories\Payment\Refund;

use App\Models\Payment;
use App\Services\StripeErrorHandler;
use Exception;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Support\Facades\Log;


class PaypalRefundRepository implements RefundInterface
{
    protected $payment;
    protected $client;

    public function __construct(Payment $payment)
    {
        $this->payment = $payment;
         //$this->client = new Client();
    }

    public function create($paymentID, $reason, $amount = 0, $refundStatus)
    {
        try {
            $status = ['partially_refunded' => 9, 'refund_pending' => 10, 'refunded' => 11];

            $payment = $this->payment::select('id', 'customer_id', 'payment_link_id', 'price', 'discount', 'currency', 'ip', 'intent_id', 'charge_id', 'refund', 'intent', 'status')
                ->where('id', $paymentID)
                ->with([
                    'link' => function ($query) {
                        $query->select('id', 'payment_gateway');
                        $query->with('gateway:id,name,public_key,secret_key');
                    }
                ])->first();

            $payPalClientId = $payment->link->gateway->public_key;
            $payPalSecret = $payment->link->gateway->secret_key;

            // Set PayPal API URL based on environment
            $payPalUrl = config('services.paypal.mode')
                ? 'https://api.sandbox.paypal.com'
                : 'https://api.paypal.com';

            $client = new Client();

            $authResponse = $client->post($payPalUrl . '/v1/oauth2/token', [
                'auth' => [$payPalClientId, $payPalSecret],
                'form_params' => [
                    'grant_type' => 'client_credentials'
                ]
            ]);

            $accessToken = json_decode($authResponse->getBody(), true)['access_token'];

            $passReason = !empty($reason['reason']) ? $reason['reason'] : 'requested_by_customer';

            if ($payment?->charge_id) {
                $refundData = [
                    'amount' => [
                        'value' => $amount,
                         'currency_code' => 'USD'
                    ],
                    'reason' => $passReason == 'other' ? 'requested_by_customer' : $passReason
                ];

                $refundResponse = $client->post($payPalUrl . '/v2/payments/captures/' . $payment->charge_id . '/refund', [
                    'headers' => [
                        'Authorization' => 'Bearer ' . $accessToken,
                        'Content-Type' => 'application/json'
                    ],
                    'json' => $refundData
                ]);

                $refundjson = json_decode($refundResponse->getBody(), true);
                $refund = (array) $refundjson;

                Payment::where('id', $paymentID)->update([
                    'refund' => response()->json($refund)->content(),
                    'status' => $status[$refundStatus]
                ]);

                return $refund;
            } else {
                throw new Exception('Payment Intent is not available.');
            }
        }
        catch (RequestException $e) {
            throw $e;
    }
}

    public function retrieve()
    {
    }

    public function update()
    {
    }

    public function list()
    {
    }

}
