<?php

namespace App\Repositories\Payment\Log;

use App\Models\PaymentLog;
use Exception;

class LogRepository implements LogInterface
{

    private $logger;

    function __construct(PaymentLog $PaymentLog)
    {
        $this->logger = $PaymentLog;
    }

    // Log payment
    public function log($data)
    {
        $log = array(
            'loggable_type' => $data['loggable_type'],
            'loggable_id' => $data['loggable_id'],
            'activity' => $data['activity'],
            'type' => $data['type'],
            'code' => $data['code'] ?? 200,
            'request' => $data['request'] ?? '',
            'response' => $data['response'] ?? '',
            'created_by' => $data['created_by'],
            'event' => $data['event'] ?? 0
        );

        $log = $this->logger->create($log);

        return $log->refresh();
    }

    // Update payment log
    public function updateLog($id, $data)
    {
        $log = $this->logger->whereId($id);
        $log->update($data);
        return $log->first()->refresh();
    }

    // Delete payment log
    public function deleteLog($id)
    {
        return $this->logger->whereId($id)->delete();
    }

    // View payment log
    public function getLog($id)
    {
        return $this->logger->whereId($id)->first();
    }

    // List payment log
    public function getLogs($condition = "")
    {
        $log = $this->logger;

        if ($condition != "") {
            $log->where($condition);
        }

        return $log->get();
    }

    // Pin to top payment log
    public function pinLog($id, $paymentLinkID, $pin)
    {
        if($pin == 1){
                $this->logger->where('loggable_id', $paymentLinkID)->update(['pin' => 0]);

                $log = $this->logger->whereId($id);
                $log->update(['pin' => 1]);
                return $log->first()->refresh();
        }else if($pin == 0){
            $log = $this->logger->whereId($id);
            $log->update(['pin' => 0]);
            return $log->first()->refresh();
        }
    }
}
