<?php

namespace App\Repositories\Coupon;

use Illuminate\Http\Request;

interface CouponInterface
{
    /**
     * Function to retrieve detailed information about a specific coupon.
     *
     * @param int $id
     * @return mixed
     */
    public function getCouponDetail($id);

    /**
     * Function to create a new coupon.
     *
     * @param Request $request
     * @return mixed
     */
    public function create(Request $request);

    /**
     * Function to update an existing coupon.
     *
     * @param Request $request
     * @return mixed
     */
    public function update(Request $request);

    /**
     * Function to retrieve a paginated list of coupons.
     *
     * @param Request $request
     * @return mixed
     */
    public function getCoupons(Request $request);

    /**
     * Function to delete a coupon by its ID.
     *
     * @param int $id
     * @return array
     */
    public function deleteById($id);

    /**
     * Function to retrieve a coupon by its ID.
     *
     * @param int $id
     * @return mixed
     */
    public function getCouponById($id);

    /**
     * Function to retrieve a coupon by its name.
     *
     * @param string $name
     * @return mixed
     */
    public function getCouponByName($name);
}
