<?php

namespace App\Repositories\BriefLog;

use App\Models\BriefLog;
use Exception;
use Illuminate\Support\Facades\Auth;

class BriefLogRepository implements BriefLogInterface
{

    private $briefLog;

    public function __construct(BriefLog $briefLog)
    {
        $this->briefLog = $briefLog;
    }

    public function log($data)
    {
        try {
            $briefLog = new $this->briefLog;

            $briefLog->brief_type = $data['brief_type'];
            $briefLog->brief_id = $data['brief_id'];
            $briefLog->activity = $data['activity'];
            $briefLog->type = $data['type'];
            $briefLog->request = $data['request'] ?? '';
            $briefLog->response = $data['response'] ?? '';
            $briefLog->created_by = $data['created_by'] ?? Auth::id();
            $briefLog->event = $data['event'] ?? 0;

            $briefLog->save();

            return $briefLog;
        } catch (Exception $e) {
            throw new Exception("Failed to log brief: " . $e->getMessage());
        }
    }

    public function updateLog($id, $data)
    {
        $briefLog = $this->briefLog->whereId($id);
        $briefLog->update($data);
        return $briefLog->first()->refresh();
    }

    public function pinLog($id, $briefID, $pin)
    {
        if($pin == 1){
                $this->briefLog->where('brief_id', $briefID)->update(['pin' => 0]);

                $log = $this->briefLog->whereId($id);
                $log->update(['pin' => 1]);
                return $log->first()->refresh();
        }else if($pin == 0){
            $log = $this->briefLog->whereId($id);
            $log->update(['pin' => 0]);
            return $log->first()->refresh();
        }
    }

    public function getLog($id)
    {
        return $this->briefLog->whereId($id)->first();
    }

    public function deleteLog($id)
    {
        return $this->briefLog->whereId($id)->delete();
    }

}
