<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Role extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'roles';
    protected $fillable = ['id', 'name', 'description', 'color', 'admin_rights', 'created_by', 'updated_by', 'status', 'created_at', 'updated_at', 'deleted_at'];

    /**
     * Summary of roles
     * The function for getting array of roles saved in database
     * @return array
     */
    public static function roles(){
        return Role::pluck('name')->toArray();
    }

     /**
      * Summary of exceptedRoles
      * The function for getting array of roles excluding the given roles
      * @param array $excludedRoles
      * @return array
      */
     public static function exceptedRoles($excludedRoles) {
        return Role::pluck('name')->diff($excludedRoles)->toArray();
     }

     /**
      * Summary of getUserIDWithRole
      * The function for getting users with given role
      * @param string $role
      * @return object
      */
     public static function getUserIDWithRole($role){
        return User::whereHas('roles', function ($query) use ($role) {
            $query->where('name', $role);
        });
     }

    public function roleLogs()
    {
        return $this->morphMany(PaymentLog::class, 'loggable');
    }
}
