<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Lead extends Model
{
    use HasFactory;

    protected $fillable =[
        'data',
    ];

    private $typeValues = [
        'logo',
        'web',
        'animation',
        'digital_service',
        'sem',
        'seo',
        'content_writing',
        'ebook'
    ];

    private $sourceValues = [
        'seo',
        'sem',
        'social_media'
    ];

    private $statusValues = [
        'new',
        'contacted',
        'nurturing',
        'qualified',
        'unqualified',
    ];

    private $ratingValues = [
        'none',
        'hot',
        'warm',
        'cold',
    ];

    private $contactMediumValues = [
        'call',
        'email',
        'chat'
    ];

    public function getTypeValues()
    {
        return $this->typeValues;
    }

    public function getSourceValues()
    {
        return $this->sourceValues;
    }

    public function getStatusValues()
    {
        return $this->statusValues;
    }

    public function getRatingValues()
    {
        return $this->ratingValues;
    }

    public function getContactMediumValues()
    {
        return $this->contactMediumValues;
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'salesperson', 'id');
    }

    public function quotes()
    {
        return $this->morphMany(Quotes::class, 'commentable');
    }

    public function paymentLogs()
    {
        return $this->morphMany(PaymentLog::class, 'loggable');
    }
}
