<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BriefActivity extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = ['custom_id', 'brief_id', 'session_id', 'data', 'fingerprint', 'brief_type', 'activity', 'activity_desc', 'no_of_visits'];

    public function loginHistory()
    {
        return $this->belongsTo(LoginHistory::class, 'session_id', 'session_id');
    }
}
