<?php

namespace App\Imports;

use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class CustomerImport implements ToModel, WithHeadingRow
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        return new User([
            'first_name' => $row['first_name'],
            'last_name' => $row['last_name'],
            'email' => $row['email'],
            'password' => Hash::make($row['password']),
            'phone' => $row['phone'],
            'address' => $row['address'],
            'company' => $row['company'],
            'city' => $row['city'],
            'state' => $row['state'],
            'zipcode' => $row['zipcode'],
            'country' => $row['country'],
            'image' => $row['image'],
            'stripe_customer_id' => $row['stripe_customer_id'] ??'',
            'stripe' => $row['stripe']??'',
            'stripe_pm_id' => $row['stripe_pm_id']??'',
            'stripe_payment_method' => $row['stripe_payment_method']??'',
            'created_by' => $row['created_by']??1,
            'target' => $row['target']??0,
            'dashboard_data' => $row['dashboard_data']??'',
            'designation' => $row['designation']??'',
        ]);
    }
}
