<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;

class StripePaymentMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $formData = Arr::pluck($request->all(), 'value', 'name');

        $request->replace([]);

        // Sanitize code
        $formData = array_map(function ($value) {
            return trim(strip_tags($value));
        }, $formData);

        // Card Expiry Date
        $expDate = $formData["exp-date"];

        if(!empty($formData["exp-date"])) {
            unset($formData['exp-date']);
        }
        
        $formData["cardNo"] = str_replace(' ', '', $formData["cardNo"]);
        $formData["cardValidity"] = $this->validateCardNumber($formData["cardNo"]);

        if (str_contains($expDate, '/')) {
            $expDate = explode("/", $expDate);
            $formData["month"] = $expDate[0];
            $formData["year"] = $expDate[1];
        } else {
            $formData["month"] = substr($expDate, 0, 2);
            $formData["year"] = substr($expDate, 2, 4);
        }

        $request->merge($formData);

        return $next($request);
    }

    function validateCardNumber($cardNumber)
    {
        // Remove any non-digit characters from the card number
        $cleanedCardNumber = preg_replace('/\D/', '', $cardNumber);

        // Convert the card number to an array of digits
        $digits = str_split($cleanedCardNumber);

        // Double every second digit starting from the right
        for ($i = count($digits) - 2; $i >= 0; $i -= 2) {
            $digits[$i] *= 2;
            if ($digits[$i] > 9) {
                $digits[$i] -= 9;
            }
        }

        // Sum all the digits
        $sum = array_sum($digits);

        // Check if the sum is divisible by 10
        return $sum % 10 === 0;
    }
}
