<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use App\Providers\RouteServiceProvider;
use App\Services\BinApiService;
use App\Services\LoginHistoryService;
use Carbon\Carbon;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Inertia\Inertia;
use App\Helper\ActivityLogHelper;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    public function logout(Request $request)
    {
        $user = auth()->user();
        $sessionId = $request->session()->getId();
        $createLogoutHistory = (new LoginHistoryService)->update(auth()->id(), $sessionId);
        
        if ($user && $user->two_step == 1) {
            $user->google2fa_secret = null;
            $user->save();
        }

        // Log the activity before logging out
        // ActivityLogHelper::staticLogActivity(
        //     'logout',
        //     'User Logged out successfully'
        // );

        $this->guard()->logout();

        $request->session()->invalidate();

        return redirect('/');
    }

    public function showLoginForm()
    {
        $brand_settings = Arr::pluck(Setting::get(), 'value', 'key');

        return Inertia::render('Login', [
            'brand_settings' => $brand_settings,
        ]);
    }

    public function login(Request $request)
    {
        $input = $this->validate($request, [
            'email' => 'required|email',
            'password' => 'required',
            'remember_me' => 'boolean',
        ]);

        // $remember = $request->has('remember_me') ? true : false;

        if (auth()->attempt(['email' => $input['email'], 'password' => $input['password']])) {
            $user = auth()->user();

            if ($user->password_expire == 1 && $user->created_at->lt(Carbon::now()->subHours(24))) {
                // Account password has expired, logout the user
                auth()->logout();
                $request->session()->invalidate();
                return Redirect::route('login')->with('message', 'Your account has expired. Please contact the administrator.');
            }

            // if ($user->two_step == 1 && $user->google2fa_secret === null) {
            //     // @ step enabled
            //     return redirect()->route('admin.2fa');
            // }

            if (auth()->user()) {
                $binLookup = (new BinApiService)->ipInfo($request->ip());
                $createLoginHistory = (new LoginHistoryService)->create($request->ip(), auth()->id(), $request->header('User-Agent'), "Login");

                if (!empty($binLookup['country'])) {
                    Session::put('country', $binLookup['country']);
                }

                return Redirect::route('admin.dashboard');
                //return redirect()->route('admin.dashboard');
            } else {
                return redirect()->back();
            }
        } else {
            return Redirect::route('login')
                ->with('message', 'Email and Password Are Wrong.');
        }
    }
}
