<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Inertia\Inertia;

class SettingController extends Controller
{
    public function index()
    {
        $databaseName = env('DB_DATABASE');

        return Inertia::render('Admin/Settings/Index', [
            'databaseName' => $databaseName,
        ]);
    }

    
    public function downloadDBBackup()
    {
        $databaseName = env('DB_DATABASE');

        $fileName = "{$databaseName}.sql";
        $filePath = storage_path("app/backups/db/{$fileName}");

        if (!file_exists($filePath)) {
            return response()->json(['error' => 'Backup file not found.'], 404);
        }

        return response()->download($filePath);
    }
}
