<?php

namespace App\Http\Controllers\Admin\Brief;

use App\Helper\LogsHelper;
use App\Http\Controllers\Controller;
use App\Services\BriefActivityService;
use App\Services\BriefLogService;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Str;

class BriefLogController extends Controller
{
    private $briefLogService, $briefActivityService;

    function __construct(BriefLogService $briefLogService, BriefActivityService $briefActivityService)
    {
        $this->briefLogService = $briefLogService;
        $this->briefActivityService = $briefActivityService;
    }

    public function getLog($id)
    {
        $data['success'] = true;
        try {
            $data['data'] = $this->briefLogService->getLogsByBriefId($id);
            return Redirect::route('');
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function create(Request $request, $id)
    {
        try {
            $log = $request->only(['activity', 'type', 'request', 'response', 'log_type', 'routeTo']);
            
            $classType = LogsHelper::quoteClasses($log['log_type'])['class'];

            $data['activity'] = $log['activity'];
            $data['type'] = $log['type'];
            $data['request'] = $log['request'];
            $data['response'] = $log['response'];
            $data['routeTo'] = $log['routeTo'];
            $data['class_type'] = $classType;
            $data['class_id'] = $id;
            $data['created_by'] = Auth::id();

            LogsHelper::log($data, $log['log_type']);

            $brief_type = ($log['log_type'] == "brief") ? "logo_brief" : Str::snake($log['log_type']);
            $this->briefActivityService->create($request, $id, $brief_type, 'create', 'Note Created Successfully', $request->fingerprint);

            return Redirect::route($data['routeTo'], ['id' => $id]);
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function update(Request $request, $id, $logID)
    {
        try {
            $log = $request->only(['activity', 'pin', 'log_type', 'routeTo']);

            $brief_type = ($log['log_type'] == "brief") ? "logo_brief" : Str::snake($log['log_type']);

            if (isset($log['activity']) && !empty($log['activity'])) {
                $data['created_by'] = Auth::id();
                $data['activity'] = $log['activity'];

                LogsHelper::updateLog($logID, $id, $data, $log['log_type']);

                $this->briefActivityService->create($request, $id, $brief_type, 'update', 'Note Updated Successfully', $request->fingerprint);
            }

            if (isset($log['pin'])) {
        
                LogsHelper::pinUnpinLog($logID, $id, $log['pin'], $log['log_type']);

                if($log['pin'] == 1){
                    $this->briefActivityService->create($request, $id, $brief_type, 'update', 'Note Pinned Successfully', $request->fingerprint);
                } else {
                    $this->briefActivityService->create($request, $id, $brief_type, 'update', 'Note Unpinned Successfully', $request->fingerprint);
                }
            
            }

            return Redirect::route($log['routeTo'], ['id' => $id]);
        } catch (Exception $ex) {
            dd($ex->getMessage());
        }
    }

    public function delete(Request $request, $id, $logID)
    {
        try {
            $log = $request->only(['log_type', 'routeTo']);

            LogsHelper::deleteLog($logID, $id, $log['log_type']);

            $brief_type = ($log['log_type'] == "brief") ? "logo_brief" : Str::snake($log['log_type']);
            $this->briefActivityService->create($request, $id, $brief_type, 'delete', 'Note Deleted Successfully', $request->fingerprint);

            return Redirect::route($log['routeTo'], ['id' => $id]);
        } catch (Exception $ex) {
            dd($ex->getMessage());
        }
    }
}
