<?php

if (!function_exists('getPaypalErrorMessage')) {
    /**
     * Get PayPal error message based on response code.
     *
     * @param string $errorCode
     * @return string
     */
    function getPaypalErrorMessage($errorCode)
    {
        $filePath = base_path('app/Repositories/Payment/Errors/paypal_errors.json');
        $errors = json_decode(file_get_contents($filePath), true);

        foreach ($errors as $item) {
            if ($item['paypal_code'] === $errorCode) {
                return $item;
                break;
            }
        }

        return 'An unknown error occurred. Please try again.';
    }
}
