<?php

namespace App\Helper;

use Illuminate\Support\Facades\Http;
use Exception;

class NeutrinoHelper
{
  private static $userID;
  private static $apiKey;
  private static $url = 'https://neutrinoapi.net/';

  public static function initialize() {
    self::$userID = env('NEUTRINO_USER_ID');
    self::$apiKey = env('NEUTRINO_API_KEY');
  }

  public static function ipInfo($ip)
  {
    self::initialize();

    try {
      $ipInfo = Http::withHeaders([
        'User-ID' => self::$userID,
        'API-Key' => self::$apiKey
      ])->get(self::$url."ip-info?ip={$ip}");

      return $ipInfo->json();
    } catch (Exception $ex) {
      return response()->json([
        "code" => $ex->getCode(),
        "message" => $ex->getMessage()
      ]);
    }
  }

  public static function userAgent($userAgent) {
    try {
      $binDetail = Http::withHeaders([
        'User-ID' => self::$userID,
        'API-Key' => self::$apiKey
      ])->get(self::$url . "ua-lookup?ua={$userAgent}");
      
      return $binDetail->json();
    } catch(Exception $ex) {
      return response()->json([
        "code" => $ex->getCode(),
        "message" => $ex->getMessage()
      ]);
    }
  }

  public static function reverseGeocode($longitude, $latitude)
  {
    self::initialize();

    try {
      $ipInfo = Http::withHeaders([
        'User-ID' => self::$userID,
        'API-Key' => self::$apiKey
      ])->get(self::$url."geocode-reverse?longitude={$longitude}&latitude={$latitude}");

      return $ipInfo->json();
    } catch (Exception $ex) {
      return response()->json([
        "code" => $ex->getCode(),
        "message" => $ex->getMessage()
      ]);
    }
  }
}
