<?php

namespace App\Helper;

use Exception;
use Illuminate\Support\Facades\Storage;

class FileHelper
{
  public static function createOrUpdateFile($token, $data)
  {
    $filePath = "briefs/$token.json";

    if (Storage::exists($filePath)) {
      $jsonContent = Storage::get($filePath);
      $existingData = json_decode($jsonContent, true);

      foreach ($data as $key => $value) {
        $existingData[$key] = $value;
      }

      $updatedJsonContent = json_encode($existingData, JSON_PRETTY_PRINT);
    } else {
      $updatedJsonContent = json_encode($data, JSON_PRETTY_PRINT);
    }

    Storage::put($filePath, $updatedJsonContent);

    return self::readFile($token);
  }

  public static function readFile($token)
  {
    $data['success'] = true;

    $filePath = "briefs/$token.json";

    if (Storage::exists($filePath)) {
      $contents = Storage::get($filePath);
      $data['data'] = json_decode($contents, true);
    } else {
      $data['code'] = 404;
      $data['success'] = false;
      $data['message'] = 'File does not exist';
    }

    return $data;
  }
}
