<?php

namespace App\Helper;

use Carbon\Carbon;

class DashboardHelper {
    public static function getDatesByDuration($value) {
        $currentDate = Carbon::now();
        $startDate = null;
        $endDate = null;

        switch ($value) {
            case "Today":
                $startDate = $currentDate->copy()->startOfDay();
                $endDate = $currentDate->copy()->endOfDay();
                break;
            case "7 days":
                $startDate = $currentDate->copy()->subDays(6)->startOfDay();
                $endDate = $currentDate->copy()->endOfDay();
                break;
            case "Last 4 weeks":
                $startDate = $currentDate->copy()->subWeeks(3)->startOfWeek();
                $endDate = $currentDate->copy()->endOfWeek();
                break;
            case "Last 3 months":
                $startDate = $currentDate->copy()->subMonths(2)->startOfMonth();
                $endDate = $currentDate->copy()->endOfMonth();
                break;
            case "Last 12 months":
                $startDate = $currentDate->copy()->subYear()->startOfYear();
                $endDate = $currentDate->copy()->endOfYear();
                break;
            case "Month to date":
                $startDate = $currentDate->copy()->startOfMonth();
                $endDate = $currentDate->copy()->endOfDay();
                break;
            case "Quarter to date":
                $startDate = Carbon::createFromDate($currentDate->year, ceil($currentDate->month / 3) * 3 - 2, 1);
                $endDate = $currentDate->copy()->endOfDay();
                break;
            case "Year to date":
                $startDate = $currentDate->copy()->startOfYear();
                $endDate = $currentDate->copy()->endOfDay();
                break;
            default:
                // Handle other cases if needed
                break;
        }

        return ['startDate' => $startDate, 'endDate' => $endDate];
    }
}